import Mathlib
open Complex

example (x y : ℝ) : (x + y) ^ 2 = x ^ 2 + 2 * x * y + y ^ 2 := by
  ring

example (x : ℝ) : (x + (0 : ℂ)).im = 0 := by
  simp

-- example (x : ℝ) : (x^2).im = 0 := by
--   invalid field 'im', the environment does not contain 'Real.im'

example (x : ℝ) : ((x : ℂ)^2).im = 0 := by
  norm_cast

lemma example1 (x : ℝ) :
    (x^2*(1 + I) + 4*x*(I - 1) + 4*(1 + I)).im = 0 ↔ x = -2 := by
  have h1 : (x^2*(1 + I) + 4*x*(I - 1) + 4*(1 + I)).im = x^2 + 4*x + 4 := by
    simp
    norm_cast
    ring
  rw [h1]
  have h2 : x ^ 2 + 4 * x + 4 = (x + 2)^2 := by
    ring
  rw [h2]
  simp
  exact Iff.symm eq_neg_iff_add_eq_zero
