import Mathlib
section Continuity
open Metric

noncomputable def f (x : ℝ) : ℝ := if x ≠ 0 then x/|x| + |x| else 0

example (δ : ℝ) (h : δ > 0) : |δ| = δ := by
  apply abs_of_pos h

lemma f_val_pos : ∀ x > 0 , f x = x + 1 := by
  intro x hx
  have h1 : f x = x / |x| + |x| := by
    rw [f]
    apply if_pos
    linarith
  rw [h1]
  rw [abs_of_pos]
  · field_simp
    ring
  · exact hx

lemma f_val_neg : ∀ x < 0 , f x = - x - 1 := by
  intro x hx
  have h1 : f x = x / |x| + |x| := by
    rw [f]
    apply if_pos
    linarith
  rw [h1]
  rw [abs_of_neg]
  · ring_nf
    have h2 : x * x⁻¹ = 1 := by
      apply mul_inv_cancel₀
      linarith
    rw [h2]
    ring
  · exact hx

-- define auxiliary functions for simplicity
def fp (x : ℝ) : ℝ := x + 1
def fm (x : ℝ) : ℝ := -1 - x

lemma fp_is_cont : ∀ x, ContinuousAt fp x := by
  intro x
  rw [continuousAt_iff]
  intro ε hε
  use ε
  constructor
  · exact hε
  · intro y hy
    rw [fp, fp]
    simp
    exact hy

lemma fm_is_cont : ∀ x, ContinuousAt fm x := by
  intro x
  rw [continuousAt_iff]
  intro ε hε
  use ε
  constructor
  · exact hε
  · intro y hy
    rw [fm, fm]
    rw [← dist_neg_neg] -- additional problem
    simp
    exact hy

lemma dist_eq_abs (x y : ℝ) : dist x y = |y - x| := by
  exact mem_sphere'.mp rfl

lemma f_not_cont_at_0 : ¬ ContinuousAt f 0 := by
  rw [continuousAt_iff]
  push_neg
  use 1/2
  constructor
  · norm_num
  intro δ hδ
  use δ/2
  constructor
  · simp
    rw [abs_of_pos]
    · linarith
    exact hδ
  · rw [dist_eq_abs]
    rw [f]
    norm_num
    rw [f_val_pos]
    · calc
      |δ / 2 + 1| = δ / 2 + 1 := by
        rw [abs_of_pos]
        linarith
      _ ≥ 1 := by
          simp
          linarith
      _ ≥ 1/2 := by
        norm_num
    norm_num
    exact hδ

/-
  all together now
-/

lemma y_between_x_0 (x y : ℝ) (h : |x - y| < x) : y > 0 := by
  calc
    y = x - (x - y) := by
      simp
    _ ≥  x - |x - y| := by
      apply tsub_le_tsub_left
      apply le_abs_self
    _ > |x - y| - |x - y| := by
      simp
      exact h
    _ = 0 := by
      simp

lemma f_cont_pos : ∀ x > 0, ContinuousAt f x := by
  intro x hx
  rw [continuousAt_iff]
  intro ε hε
  use min ε x
  constructor
  · exact lt_min hε hx
  intro y hy
  rw [dist_eq_abs] at hy
  rw [dist_eq_abs]
  have hyp : y > 0 := by
    apply y_between_x_0 x y
    have h1 : min ε x ≤ x := by
      simp
    linarith
  rw [f_val_pos, f_val_pos]
  · simp
    calc
      |x - y| < min ε x := by
        exact hy
      _ ≤ ε := by
        simp
  · exact hyp
  · exact hx

lemma f_cont_neg : ∀ x < 0, ContinuousAt f x := by
  intro x hx
  rw [continuousAt_iff]
  intro ε hε
  use min ε (-x)
  constructor
  · have hmx : -x > 0 := by
      linarith
    exact lt_min hε hmx
  intro y hy
  rw [dist_eq_abs] at hy
  rw [dist_eq_abs]
  have hyp : -y > 0 := by
    apply y_between_x_0 (-x) (-y)
    rw [← abs_neg]
    ring_nf
    have h1 : min ε (-x) ≤ -x := by
      simp
    linarith
  rw [f_val_neg, f_val_neg]
  · simp
    calc
      |-x + y| = |x - y| := by
        rw [← abs_neg]
        ring_nf
      _ < min ε (-x) := by
        exact hy
      _ ≤ ε := by
        simp
  · linarith
  · exact hx

theorem example2 : ∀ x, ContinuousAt f x ↔ x ≠ 0 := by
  intro x
  constructor
  · contrapose
    intro h
    push_neg at h
    rw [h]
    exact f_not_cont_at_0
  · intro h
    rw [ne_iff_lt_or_gt] at h
    rcases h with ha | ha
    · apply f_cont_neg
      exact ha
    · apply f_cont_pos
      exact ha

end Continuity
